"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "for_permission_set"


async def get(hub, ctx, instance_arn: str, permission_set_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Obtains the inline policy assigned to the permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the permission set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.inline_policy.for_permission_set_.get(
                ctx, instance_arn=value, permission_set_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.inline_policy.for_permission_set.get instance_arn=value, permission_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="get_inline_policy_for_permission_set",
        op_kwargs={"InstanceArn": instance_arn, "PermissionSetArn": permission_set_arn},
    )
