"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    instance_arn: str,
    target_id: str,
    target_type: str,
    permission_set_arn: str,
    principal_type: str,
    principal_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.  The term principal here refers to a user or group that is defined in Amazon Web Services SSO.   As part of a successful CreateAccountAssignment call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the SSO-created IAM role. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call  ProvisionPermissionSet  to make these updates.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        target_id(str): TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).
        target_type(str): The entity type for which the assignment will be created.
        permission_set_arn(str): The ARN of the permission set that the admin wants to grant the principal access to.
        principal_type(str): The entity type for which the assignment will be created.
        principal_id(str): An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the Amazon Web Services SSO Identity Store API Reference.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.account.assignment.init.create(
                ctx,
                instance_arn=value,
                target_id=value,
                target_type=value,
                permission_set_arn=value,
                principal_type=value,
                principal_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.account.assignment.init.create instance_arn=value, target_id=value, target_type=value, permission_set_arn=value, principal_type=value, principal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="create_account_assignment",
        op_kwargs={
            "InstanceArn": instance_arn,
            "TargetId": target_id,
            "TargetType": target_type,
            "PermissionSetArn": permission_set_arn,
            "PrincipalType": principal_type,
            "PrincipalId": principal_id,
        },
    )


async def delete(
    hub,
    ctx,
    instance_arn: str,
    target_id: str,
    target_type: str,
    permission_set_arn: str,
    principal_type: str,
    principal_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        target_id(str): TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).
        target_type(str): The entity type for which the assignment will be deleted.
        permission_set_arn(str): The ARN of the permission set that will be used to remove access.
        principal_type(str): The entity type for which the assignment will be deleted.
        principal_id(str): An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the Amazon Web Services SSO Identity Store API Reference.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.account.assignment.init.delete(
                ctx,
                instance_arn=value,
                target_id=value,
                target_type=value,
                permission_set_arn=value,
                principal_type=value,
                principal_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.account.assignment.init.delete instance_arn=value, target_id=value, target_type=value, permission_set_arn=value, principal_type=value, principal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="delete_account_assignment",
        op_kwargs={
            "InstanceArn": instance_arn,
            "TargetId": target_id,
            "TargetType": target_type,
            "PermissionSetArn": permission_set_arn,
            "PrincipalType": principal_type,
            "PrincipalId": principal_id,
        },
    )


async def list_all(
    hub,
    ctx,
    instance_arn: str,
    account_id: str,
    permission_set_arn: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the assignee of the specified Amazon Web Services account with the specified permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        account_id(str): The identifier of the Amazon Web Services account from which to list the assignments.
        permission_set_arn(str): The ARN of the permission set from which to list assignments.
        max_results(int, optional): The maximum number of results to display for the assignment. Defaults to None.
        next_token(str, optional): The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.account.assignment.init.list_all(
                ctx, instance_arn=value, account_id=value, permission_set_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.account.assignment.init.list_all instance_arn=value, account_id=value, permission_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="list_account_assignments",
        op_kwargs={
            "InstanceArn": instance_arn,
            "AccountId": account_id,
            "PermissionSetArn": permission_set_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
