"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, role_name: str, account_id: str, access_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the STS short-term credentials for a given role name that is assigned to the user.

    Args:
        role_name(str): The friendly name of the role that is assigned to the user.
        account_id(str): The identifier for the AWS account that is assigned to the user.
        access_token(str): The token issued by the CreateToken API call. For more information, see CreateToken in the AWS SSO OIDC API Reference Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso.role_credential.get_all(
                ctx, role_name=value, account_id=value, access_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso.role_credential.get_all role_name=value, account_id=value, access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso",
        operation="get_role_credentials",
        op_kwargs={
            "roleName": role_name,
            "accountId": account_id,
            "accessToken": access_token,
        },
    )
