"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def logout(hub, ctx, access_token: str) -> None:
    r"""
    **Autogenerated function**

    Removes the client- and server-side session that is associated with the user.

    Args:
        access_token(str): The token issued by the CreateToken API call. For more information, see CreateToken in the AWS SSO OIDC API Reference Guide.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso.init.logout(ctx, access_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso.init.logout access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso",
        operation="logout",
        op_kwargs={"accessToken": access_token},
    )
