"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    access_token: str,
    account_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all roles that are assigned to the user for a given AWS account.

    Args:
        next_token(str, optional): The page token from the previous response output when you request subsequent pages. Defaults to None.
        max_results(int, optional): The number of items that clients can request per page. Defaults to None.
        access_token(str): The token issued by the CreateToken API call. For more information, see CreateToken in the AWS SSO OIDC API Reference Guide.
        account_id(str): The identifier for the AWS account that is assigned to the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso.account.role.list_all(
                ctx, access_token=value, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso.account.role.list_all access_token=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso",
        operation="list_account_roles",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "accessToken": access_token,
            "accountId": account_id,
        },
    )
