"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, access_token: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all AWS accounts assigned to the user. These AWS accounts are assigned by the administrator of the account. For more information, see Assign User Access in the AWS SSO User Guide. This operation returns a paginated response.

    Args:
        next_token(str, optional): (Optional) When requesting subsequent pages, this is the page token from the previous response output. Defaults to None.
        max_results(int, optional): This is the number of items clients can request per page. Defaults to None.
        access_token(str): The token issued by the CreateToken API call. For more information, see CreateToken in the AWS SSO OIDC API Reference Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso.account.init.list_all(ctx, access_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso.account.init.list_all access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso",
        operation="list_accounts",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "accessToken": access_token,
        },
    )
