"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_token: str,
    event_data: str,
    event_time: str,
    event_type: str,
    incident_record_arn: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a custom timeline event on the incident details page of an incident record. Timeline events are automatically created by Incident Manager, marking key moment during an incident. You can create custom timeline events to mark important events that are automatically detected by Incident Manager.

    Args:
        client_token(str): A token ensuring that the action is called only once with the specified details.
        event_data(str): A short description of the event.
        event_time(str): The time that the event occurred.
        event_type(str): The type of the event. You can create timeline events of type Custom Event.
        incident_record_arn(str): The Amazon Resource Name (ARN) of the incident record you are adding the event to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.timeline_event.create(
                ctx,
                client_token=value,
                event_data=value,
                event_time=value,
                event_type=value,
                incident_record_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.timeline_event.create client_token=value, event_data=value, event_time=value, event_type=value, incident_record_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="create_timeline_event",
        op_kwargs={
            "clientToken": client_token,
            "eventData": event_data,
            "eventTime": event_time,
            "eventType": event_type,
            "incidentRecordArn": incident_record_arn,
        },
    )


async def delete(hub, ctx, event_id: str, incident_record_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a timeline event from an incident.

    Args:
        event_id(str): The ID of the event you are updating. You can find this by using ListTimelineEvents.
        incident_record_arn(str): The Amazon Resource Name (ARN) of the incident that the event is part of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.timeline_event.delete(
                ctx, event_id=value, incident_record_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.timeline_event.delete event_id=value, incident_record_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="delete_timeline_event",
        op_kwargs={"eventId": event_id, "incidentRecordArn": incident_record_arn},
    )


async def get(hub, ctx, event_id: str, incident_record_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a timeline event based on its ID and incident record.

    Args:
        event_id(str): The ID of the event. You can get an event's ID when you create it or by using ListTimelineEvents.
        incident_record_arn(str): The Amazon Resource Name (ARN) of the incident that the timeline event is part of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.timeline_event.get(
                ctx, event_id=value, incident_record_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.timeline_event.get event_id=value, incident_record_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="get_timeline_event",
        op_kwargs={"eventId": event_id, "incidentRecordArn": incident_record_arn},
    )


async def list_all(
    hub,
    ctx,
    incident_record_arn: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists timeline events of the specified incident record.

    Args:
        filters(List, optional): Filters the timeline events based on the provided conditional values. You can filter timeline events using the following keys:    eventTime     eventType   . Defaults to None.
        incident_record_arn(str): The Amazon Resource Name (ARN) of the incident that the event is part of.
        max_results(int, optional): The maximum number of results per page. Defaults to None.
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.
        sort_by(str, optional): Sort by the specified key value pair. Defaults to None.
        sort_order(str, optional): Sorts the order of timeline events by the value specified in the sortBy field. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.timeline_event.list_all(
                ctx, incident_record_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.timeline_event.list_all incident_record_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="list_timeline_events",
        op_kwargs={
            "filters": filters,
            "incidentRecordArn": incident_record_arn,
            "maxResults": max_results,
            "nextToken": next_token,
            "sortBy": sort_by,
            "sortOrder": sort_order,
        },
    )


async def update(
    hub,
    ctx,
    client_token: str,
    event_id: str,
    incident_record_arn: str,
    event_data: str = None,
    event_time: str = None,
    event_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a timeline event. You can update events of type Custom Event.

    Args:
        client_token(str): A token ensuring that the action is called only once with the specified details.
        event_data(str, optional): A short description of the event. Defaults to None.
        event_id(str): The ID of the event you are updating. You can find this by using ListTimelineEvents.
        event_time(str, optional): The time that the event occurred. Defaults to None.
        event_type(str, optional): The type of the event. You can update events of type Custom Event. Defaults to None.
        incident_record_arn(str): The Amazon Resource Name (ARN) of the incident that the timeline event is part of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.timeline_event.update(
                ctx, client_token=value, event_id=value, incident_record_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.timeline_event.update client_token=value, event_id=value, incident_record_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="update_timeline_event",
        op_kwargs={
            "clientToken": client_token,
            "eventData": event_data,
            "eventId": event_id,
            "eventTime": event_time,
            "eventType": event_type,
            "incidentRecordArn": incident_record_arn,
        },
    )
