"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    incident_template: Dict,
    name: str,
    actions: List = None,
    chat_channel: Dict = None,
    client_token: str = None,
    display_name: str = None,
    engagements: List = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a response plan that automates the initial response to incidents. A response plan engages contacts, starts chat channel collaboration, and initiates runbooks at the beginning of an incident.

    Args:
        actions(List, optional): The actions that the response plan starts at the beginning of an incident. Defaults to None.
        chat_channel(Dict, optional): The AWS Chatbot chat channel used for collaboration during an incident. Defaults to None.
        client_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.
        display_name(str, optional): The long format of the response plan name. This field can contain spaces. Defaults to None.
        engagements(List, optional): The contacts and escalation plans that the response plan engages during an incident. Defaults to None.
        incident_template(Dict): Details used to create an incident when using this response plan.
        name(str): The short format name of the response plan. Can't include spaces.
        tags(Dict, optional): A list of tags that you are adding to the response plan. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.response_plan.create(
                ctx, incident_template=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.response_plan.create incident_template=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="create_response_plan",
        op_kwargs={
            "actions": actions,
            "chatChannel": chat_channel,
            "clientToken": client_token,
            "displayName": display_name,
            "engagements": engagements,
            "incidentTemplate": incident_template,
            "name": name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch alarms and EventBridge events from creating an incident with this response plan.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the response plan.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.response_plan.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.response_plan.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="delete_response_plan",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the details of the specified response plan.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the response plan.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.response_plan.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.response_plan.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="get_response_plan",
        op_kwargs={"arn": arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all response plans in your account.

    Args:
        max_results(int, optional): The maximum number of response plans per page. Defaults to None.
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.response_plan.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.response_plan.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="list_response_plans",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    arn: str,
    actions: List = None,
    chat_channel: Dict = None,
    client_token: str = None,
    display_name: str = None,
    engagements: List = None,
    incident_template_dedupe_string: str = None,
    incident_template_impact: int = None,
    incident_template_notification_targets: List = None,
    incident_template_summary: str = None,
    incident_template_title: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified response plan.

    Args:
        actions(List, optional): The actions that this response plan takes at the beginning of an incident. Defaults to None.
        arn(str): The Amazon Resource Name (ARN) of the response plan.
        chat_channel(Dict, optional): The AWS Chatbot chat channel used for collaboration during an incident. Defaults to None.
        client_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.
        display_name(str, optional): The long format name of the response plan. Can't contain spaces. Defaults to None.
        engagements(List, optional): The contacts and escalation plans that Incident Manager engages at the start of the incident. Defaults to None.
        incident_template_dedupe_string(str, optional): Used to create only one incident record for an incident. Defaults to None.
        incident_template_impact(int, optional): Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.  Possible impacts:     5 - Severe impact    4 - High impact    3 - Medium impact    2 - Low impact    1 - No impact  . Defaults to None.
        incident_template_notification_targets(List, optional): The SNS targets that AWS Chatbot uses to notify the chat channels and perform actions on the incident record. Defaults to None.
        incident_template_summary(str, optional): A brief summary of the incident. This typically contains what has happened, what's currently happening, and next steps. Defaults to None.
        incident_template_title(str, optional): The short format name of the incident. Can't contain spaces. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.response_plan.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.response_plan.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="update_response_plan",
        op_kwargs={
            "actions": actions,
            "arn": arn,
            "chatChannel": chat_channel,
            "clientToken": client_token,
            "displayName": display_name,
            "engagements": engagements,
            "incidentTemplateDedupeString": incident_template_dedupe_string,
            "incidentTemplateImpact": incident_template_impact,
            "incidentTemplateNotificationTargets": incident_template_notification_targets,
            "incidentTemplateSummary": incident_template_summary,
            "incidentTemplateTitle": incident_template_title,
        },
    )
