"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, policy_id: str, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the resource policy that AWS Resource Access Manager uses to share your Incident Manager resource.

    Args:
        policy_id(str): The ID of the resource policy you're deleting.
        resource_arn(str): The Amazon Resource Name (ARN) of the resource you're deleting the policy from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.resource.policy.delete(
                ctx, policy_id=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.resource.policy.delete policy_id=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="delete_resource_policy",
        op_kwargs={"policyId": policy_id, "resourceArn": resource_arn},
    )


async def get_all(
    hub, ctx, resource_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the resource policies attached to the specified response plan.

    Args:
        max_results(int, optional): The maximum number of resource policies to display per page of results. Defaults to None.
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the response plan with the attached resource policy. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.resource.policy.get_all(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.resource.policy.get_all resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="get_resource_policies",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "resourceArn": resource_arn,
        },
    )


async def put(hub, ctx, policy: str, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds a resource policy to the specified response plan.

    Args:
        policy(str): Details of the resource policy.
        resource_arn(str): The Amazon Resource Name (ARN) of the response plan you're adding the resource policy to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.resource.policy.put(
                ctx, policy=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.resource.policy.put policy=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="put_resource_policy",
        op_kwargs={"policy": policy, "resourceArn": resource_arn},
    )
