"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "replication_set"


async def create(hub, ctx, regions: Dict, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    A replication set replicates and encrypts your data to the provided Regions with the provided KMS key.

    Args:
        client_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.
        regions(Dict): The Regions that Incident Manager replicates your data to. You can have up to three Regions in your replication set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.replication_set_.create(ctx, regions=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.replication_set.create regions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="create_replication_set",
        op_kwargs={"clientToken": client_token, "regions": regions},
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes all Regions in your replication set. Deleting the replication set deletes all Incident Manager data.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the replication set you're deleting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.replication_set_.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.replication_set.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="delete_replication_set",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve your Incident Manager replication set.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the replication set you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.replication_set_.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.replication_set.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="get_replication_set",
        op_kwargs={"arn": arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists details about the replication set configured in your account.

    Args:
        max_results(int, optional): The maximum number of results per page. . Defaults to None.
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.replication_set_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.replication_set.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="list_replication_sets",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(hub, ctx, actions: List, arn: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Add or delete Regions from your replication set.

    Args:
        actions(List): An action to add or delete a Region.
        arn(str): The Amazon Resource Name (ARN) of the replication set you're updating.
        client_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.replication_set_.update(
                ctx, actions=value, arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.replication_set.update actions=value, arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="update_replication_set",
        op_kwargs={"actions": actions, "arn": arn, "clientToken": client_token},
    )
