"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an incident record from Incident Manager.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the incident record you are deleting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.incident.record.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.incident.record.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="delete_incident_record",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of the specified incident record.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the incident record.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.incident.record.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.incident.record.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="get_incident_record",
        op_kwargs={"arn": arn},
    )


async def list_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the incident record you want to update.

    Args:
        filters(List, optional): Filter the list of incident records you are searching through. You can filter on the following keys:    creationTime     impact     status     createdBy   . Defaults to None.
        max_results(int, optional): The maximum number of results per page. Defaults to None.
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.incident.record.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.incident.record.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="list_incident_records",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    arn: str,
    chat_channel: Dict = None,
    client_token: str = None,
    impact: int = None,
    notification_targets: List = None,
    status: str = None,
    summary: str = None,
    title: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update the details of an incident record. You can use this action to update an incident record from the defined chat channel. For more information about using actions in chat channels, see Interacting through chat.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the incident record you are updating.
        chat_channel(Dict, optional): The AWS Chatbot chat channel for responders to collaborate in. Defaults to None.
        client_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.
        impact(int, optional): Defines the impact to customers and applications. Providing an impact overwrites the impact provided by the response plan.  Possible impacts:     1 - Critical impact, this typically relates to full application failure that impacts many to all customers.     2 - High impact, partial application failure with impact to many customers.    3 - Medium impact, the application is providing reduced service to customers.    4 - Low impact, customer might aren't impacted by the problem yet.    5 - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.  . Defaults to None.
        notification_targets(List, optional): The SNS targets that AWS Chatbot uses to notify the chat channel of updates to an incident. You can also make updates to the incident through the chat channel using the SNS topics.  Using multiple SNS topics creates redundancy in the case that a Region is down during the incident. Defaults to None.
        status(str, optional): The status of the incident. An incident can be Open or Resolved. Defaults to None.
        summary(str, optional): The summary describes what has happened during the incident. Defaults to None.
        title(str, optional): The title of the incident is a brief and easily recognizable. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.incident.record.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.incident.record.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="update_incident_record",
        op_kwargs={
            "arn": arn,
            "chatChannel": chat_channel,
            "clientToken": client_token,
            "impact": impact,
            "notificationTargets": notification_targets,
            "status": status,
            "summary": summary,
            "title": title,
        },
    )
