"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def start(
    hub,
    ctx,
    response_plan_arn: str,
    client_token: str = None,
    impact: int = None,
    related_items: List = None,
    title: str = None,
    trigger_details: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used to start an incident from CloudWatch alarms, EventBridge events, or manually.

    Args:
        client_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.
        impact(int, optional): Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.  Possible impacts:     1 - Critical impact, this typically relates to full application failure that impacts many to all customers.     2 - High impact, partial application failure with impact to many customers.    3 - Medium impact, the application is providing reduced service to customers.    4 - Low impact, customer might aren't impacted by the problem yet.    5 - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.  . Defaults to None.
        related_items(List, optional): Add related items to the incident for other responders to use. Related items are AWS resources, external links, or files uploaded to an S3 bucket. . Defaults to None.
        response_plan_arn(str): The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat channels, SNS topics, runbooks, title, and impact of the incident. .
        title(str, optional): Provide a title for the incident. Providing a title overwrites the title provided by the response plan. . Defaults to None.
        trigger_details(Dict, optional): Details of what created the incident record in Incident Manager. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_incident.incident.init.start(ctx, response_plan_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_incident.incident.init.start response_plan_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-incidents",
        operation="start_incident",
        op_kwargs={
            "clientToken": client_token,
            "impact": impact,
            "relatedItems": related_items,
            "responsePlanArn": response_plan_arn,
            "title": title,
            "triggerDetails": trigger_details,
        },
    )
