"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, page_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the engagements to contact channels that have been acknowledged.

    Args:
        page_id(str): The Amazon Resource Name (ARN) of the engagement to a specific contact channel.
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of acknowledgements per page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.page.receipt.list_all(ctx, page_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.page.receipt.list_all page_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="list_page_receipts",
        op_kwargs={
            "PageId": page_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
