"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def accept(
    hub,
    ctx,
    page_id: str,
    accept_type: str,
    accept_code: str,
    contact_channel_id: str = None,
    note: str = None,
    accept_code_validation: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used to acknowledge an engagement to a contact channel during an incident.

    Args:
        page_id(str): The Amazon Resource Name (ARN) of the engagement to a contact channel.
        contact_channel_id(str, optional): The ARN of the contact channel. Defaults to None.
        accept_type(str): The type indicates if the page was DELIVERED or READ.
        note(str, optional): Information provided by the user when the user acknowledges the page. Defaults to None.
        accept_code(str): The accept code is a 6-digit code used to acknowledge the page.
        accept_code_validation(str, optional): An optional field that Incident Manager uses to ENFORCE AcceptCode validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page. Incident Manager can also IGNORE AcceptCode validation. Ignoring AcceptCode validation causes Incident Manager to accept any value entered for the AcceptCode. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.page.init.accept(
                ctx, page_id=value, accept_type=value, accept_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.page.init.accept page_id=value, accept_type=value, accept_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="accept_page",
        op_kwargs={
            "PageId": page_id,
            "ContactChannelId": contact_channel_id,
            "AcceptType": accept_type,
            "Note": note,
            "AcceptCode": accept_code,
            "AcceptCodeValidation": accept_code_validation,
        },
    )


async def describe(hub, ctx, page_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists details of the engagement to a contact channel.

    Args:
        page_id(str): The ID of the engagement to a contact channel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.page.init.describe(ctx, page_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.page.init.describe page_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="describe_page",
        op_kwargs={"PageId": page_id},
    )
