"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, contact_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the engagements to a contact's contact channels.

    Args:
        contact_id(str): The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of engagements to contact channels to list per page of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.page.by.contact.list(ctx, contact_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.page.by.contact.list contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="list_pages_by_contact",
        op_kwargs={
            "ContactId": contact_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
