"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, engagement_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to describe the engagement that occurred during an incident.

    Args:
        engagement_id(str): The Amazon Resource Name (ARN) of the engagement you want the details of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.engagement.describe(ctx, engagement_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.engagement.describe engagement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="describe_engagement",
        op_kwargs={"EngagementId": engagement_id},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    incident_id: str = None,
    time_range_value: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all engagements that have happened in an incident.

    Args:
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of engagements per page of results. Defaults to None.
        incident_id(str, optional): The Amazon Resource Name (ARN) of the incident you're listing engagements for. Defaults to None.
        time_range_value(Dict, optional): The time range to lists engagements for an incident. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.engagement.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.engagement.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="list_engagements",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "IncidentId": incident_id,
            "TimeRangeValue": time_range_value,
        },
    )


async def start(
    hub,
    ctx,
    contact_id: str,
    sender: str,
    subject: str,
    content: str,
    public_subject: str = None,
    public_content: str = None,
    incident_id: str = None,
    idempotency_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.

    Args:
        contact_id(str): The Amazon Resource Name (ARN) of the contact being engaged.
        sender(str): The user that started the engagement.
        subject(str): The secure subject of the message that was sent to the contact. Use this field for engagements to VOICE or EMAIL.
        content(str): The secure content of the message that was sent to the contact. Use this field for engagements to VOICE or EMAIL.
        public_subject(str, optional): The insecure subject of the message that was sent to the contact. Use this field for engagements to SMS. Defaults to None.
        public_content(str, optional): The insecure content of the message that was sent to the contact. Use this field for engagements to SMS. Defaults to None.
        incident_id(str, optional): The ARN of the incident that the engagement is part of. Defaults to None.
        idempotency_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.engagement.start(
                ctx, contact_id=value, sender=value, subject=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.engagement.start contact_id=value, sender=value, subject=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="start_engagement",
        op_kwargs={
            "ContactId": contact_id,
            "Sender": sender,
            "Subject": subject,
            "Content": content,
            "PublicSubject": public_subject,
            "PublicContent": public_content,
            "IncidentId": incident_id,
            "IdempotencyToken": idempotency_token,
        },
    )


async def stop(hub, ctx, engagement_id: str, reason: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further contacts aren't engaged.

    Args:
        engagement_id(str): The Amazon Resource Name (ARN) of the engagement.
        reason(str, optional): The reason that you're stopping the engagement. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.engagement.stop(ctx, engagement_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.engagement.stop engagement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="stop_engagement",
        op_kwargs={"EngagementId": engagement_id, "Reason": reason},
    )
