"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, contact_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the resource policies attached to the specified contact or escalation plan.

    Args:
        contact_arn(str): The Amazon Resource Name (ARN) of the contact or escalation plan.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.policy.get(ctx, contact_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.policy.get contact_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="get_contact_policy",
        op_kwargs={"ContactArn": contact_arn},
    )


async def put(hub, ctx, contact_arn: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds a resource to the specified contact or escalation plan.

    Args:
        contact_arn(str): The Amazon Resource Name (ARN) of the contact or escalation plan.
        policy(str): Details of the resource policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.policy.put(
                ctx, contact_arn=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.policy.put contact_arn=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="put_contact_policy",
        op_kwargs={"ContactArn": contact_arn, "Policy": policy},
    )
