"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    alias: str,
    type_: str,
    plan: Dict,
    display_name: str = None,
    tags: List = None,
    idempotency_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident.

    Args:
        alias(str): The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable. .
        display_name(str, optional): The full name of the contact or escalation plan. . Defaults to None.
        type_(str): To create an escalation plan use ESCALATION. To create a contact use PERSONAL.
        plan(Dict): A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts. .
        tags(List, optional): Adds a tag to the target. You can only tag resources created in the first Region of your replication set. . Defaults to None.
        idempotency_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.init.create(
                ctx, alias=value, type_=value, plan=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.init.create alias=value, type_=value, plan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="create_contact",
        op_kwargs={
            "Alias": alias,
            "DisplayName": display_name,
            "Type": type_,
            "Plan": plan,
            "Tags": tags,
            "IdempotencyToken": idempotency_token,
        },
    )


async def delete(hub, ctx, contact_id: str) -> Dict:
    r"""
    **Autogenerated function**

    To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all escalation plans and related response plans. Deleting an escalation plan removes it from all related response plans. You will have to recreate the contact and its contact channels before you can use it again.

    Args:
        contact_id(str): The Amazon Resource Name (ARN) of the contact that you're deleting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.init.delete(ctx, contact_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.init.delete contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="delete_contact",
        op_kwargs={"ContactId": contact_id},
    )


async def get(hub, ctx, contact_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the specified contact or escalation plan.

    Args:
        contact_id(str): The Amazon Resource Name (ARN) of the contact or escalation plan.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.init.get(ctx, contact_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.init.get contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="get_contact",
        op_kwargs={"ContactId": contact_id},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    alias_prefix: str = None,
    type_: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all contacts and escalation plans in Incident Manager.

    Args:
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of contacts and escalation plans per page of results. Defaults to None.
        alias_prefix(str, optional): Used to list only contacts who's aliases start with the specified prefix. Defaults to None.
        type_(str, optional): The type of contact. A contact is type PERSONAL and an escalation plan is type ESCALATION. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="list_contacts",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "AliasPrefix": alias_prefix,
            "Type": type_,
        },
    )


async def update(
    hub, ctx, contact_id: str, display_name: str = None, plan: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the contact or escalation plan specified.

    Args:
        contact_id(str): The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.
        display_name(str, optional): The full name of the contact or escalation plan. Defaults to None.
        plan(Dict, optional): A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.init.update(ctx, contact_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.init.update contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="update_contact",
        op_kwargs={"ContactId": contact_id, "DisplayName": display_name, "Plan": plan},
    )
