"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def activate(hub, ctx, contact_channel_id: str, activation_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been activated.

    Args:
        contact_channel_id(str): The Amazon Resource Name (ARN) of the contact channel.
        activation_code(str): The code sent to the contact channel when it was created in the contact. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.channel.activate(
                ctx, contact_channel_id=value, activation_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.channel.activate contact_channel_id=value, activation_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="activate_contact_channel",
        op_kwargs={
            "ContactChannelId": contact_channel_id,
            "ActivationCode": activation_code,
        },
    )


async def create(
    hub,
    ctx,
    contact_id: str,
    name: str,
    type_: str,
    delivery_address: Dict,
    defer_activation: bool = None,
    idempotency_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    A contact channel is the method that Incident Manager uses to engage your contact.

    Args:
        contact_id(str): The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
        name(str): The name of the contact channel.
        type_(str): Incident Manager supports three types of contact channels:    SMS     VOICE     EMAIL   .
        delivery_address(Dict): The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:   SMS - '+' followed by the country code and phone number   VOICE - '+' followed by the country code and phone number   EMAIL - any standard email format  .
        defer_activation(bool, optional): If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated. Defaults to None.
        idempotency_token(str, optional): A token ensuring that the action is called only once with the specified details. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.channel.create(
                ctx, contact_id=value, name=value, type_=value, delivery_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.channel.create contact_id=value, name=value, type_=value, delivery_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="create_contact_channel",
        op_kwargs={
            "ContactId": contact_id,
            "Name": name,
            "Type": type_,
            "DeliveryAddress": delivery_address,
            "DeferActivation": defer_activation,
            "IdempotencyToken": idempotency_token,
        },
    )


async def deactivate(hub, ctx, contact_channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.

    Args:
        contact_channel_id(str): The Amazon Resource Name (ARN) of the contact channel you're deactivating.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.channel.deactivate(
                ctx, contact_channel_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.channel.deactivate contact_channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="deactivate_contact_channel",
        op_kwargs={"ContactChannelId": contact_channel_id},
    )


async def delete(hub, ctx, contact_channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a contact, you won't be able to engage that contact during an incident.

    Args:
        contact_channel_id(str): The Amazon Resource Name (ARN) of the contact channel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.channel.delete(
                ctx, contact_channel_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.channel.delete contact_channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="delete_contact_channel",
        op_kwargs={"ContactChannelId": contact_channel_id},
    )


async def get(hub, ctx, contact_channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    List details about a specific contact channel.

    Args:
        contact_channel_id(str): The Amazon Resource Name (ARN) of the contact channel you want information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.channel.get(ctx, contact_channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.channel.get contact_channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="get_contact_channel",
        op_kwargs={"ContactChannelId": contact_channel_id},
    )


async def list_all(
    hub, ctx, contact_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all contact channels for the specified contact.

    Args:
        contact_id(str): The Amazon Resource Name (ARN) of the contact. .
        next_token(str, optional): The pagination token to continue to the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of contact channels per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.channel.list_all(ctx, contact_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.channel.list_all contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="list_contact_channels",
        op_kwargs={
            "ContactId": contact_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub, ctx, contact_channel_id: str, name: str = None, delivery_address: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a contact's contact channel.

    Args:
        contact_channel_id(str): The Amazon Resource Name (ARN) of the contact channel you want to update.
        name(str, optional): The name of the contact channel. Defaults to None.
        delivery_address(Dict, optional): The details that Incident Manager uses when trying to engage the contact channel. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.contact.channel.update(
                ctx, contact_channel_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.contact.channel.update contact_channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="update_contact_channel",
        op_kwargs={
            "ContactChannelId": contact_channel_id,
            "Name": name,
            "DeliveryAddress": delivery_address,
        },
    )
