"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(hub, ctx, contact_channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in the console or with the ActivateChannel action. Incident Manager can't engage a contact channel until it has been activated.

    Args:
        contact_channel_id(str): The Amazon Resource Name (ARN) of the contact channel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm_contact.activation_code.send(ctx, contact_channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm_contact.activation_code.send contact_channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm-contacts",
        operation="send_activation_code",
        op_kwargs={"ContactChannelId": contact_channel_id},
    )
