"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def register(
    hub,
    ctx,
    window_id: str,
    task_arn: str,
    task_type: str,
    targets: List = None,
    service_role_arn: str = None,
    task_parameters: Dict = None,
    task_invocation_parameters: Dict = None,
    priority: int = None,
    max_concurrency: str = None,
    max_errors: str = None,
    logging_info: Dict = None,
    name: str = None,
    description: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new task to a maintenance window.

    Args:
        window_id(str): The ID of the maintenance window the task should be added to.
        targets(List, optional): The targets (either instances or maintenance window targets).  One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don't specify targets, see Registering maintenance window tasks without targets in the Amazon Web Services Systems Manager User Guide.  Specify instances using the following format:   Key=InstanceIds,Values=<instance-id-1>,<instance-id-2>  Specify maintenance window targets using the following format:  Key=WindowTargetIds,Values=<window-target-id-1>,<window-target-id-2> . Defaults to None.
        task_arn(str): The ARN of the task to run.
        service_role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run RegisterTaskWithMaintenanceWindow. For more information, see the following topics in the in the Amazon Web Services Systems Manager User Guide:    Using service-linked roles for Systems Manager     Should I use a service-linked role or a custom service role to run maintenance window tasks?    . Defaults to None.
        task_type(str): The type of task being registered.
        task_parameters(Dict, optional): The parameters that should be passed to the task when it is run.   TaskParameters has been deprecated. To specify parameters to pass to a task when it runs, instead use the Parameters option in the TaskInvocationParameters structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters. . Defaults to None.
        task_invocation_parameters(Dict, optional): The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty. . Defaults to None.
        priority(int, optional): The priority of the task in the maintenance window, the lower the number the higher the priority. Tasks in a maintenance window are scheduled in priority order with tasks that have the same priority scheduled in parallel. Defaults to None.
        max_concurrency(str, optional): The maximum number of targets this task can be run for in parallel.  For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of 1. This value doesn't affect the running of your task. . Defaults to None.
        max_errors(str, optional): The maximum number of errors allowed before this task stops being scheduled.  For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of 1. This value doesn't affect the running of your task. . Defaults to None.
        logging_info(Dict, optional): A structure containing information about an Amazon Simple Storage Service (Amazon S3) bucket to write instance-level logs to.    LoggingInfo has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters. . Defaults to None.
        name(str, optional): An optional name for the task. Defaults to None.
        description(str, optional): An optional description for the task. Defaults to None.
        client_token(str, optional): User-provided idempotency token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.task.with_maintenance_window.register(
                ctx, window_id=value, task_arn=value, task_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.task.with_maintenance_window.register window_id=value, task_arn=value, task_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="register_task_with_maintenance_window",
        op_kwargs={
            "WindowId": window_id,
            "Targets": targets,
            "TaskArn": task_arn,
            "ServiceRoleArn": service_role_arn,
            "TaskType": task_type,
            "TaskParameters": task_parameters,
            "TaskInvocationParameters": task_invocation_parameters,
            "Priority": priority,
            "MaxConcurrency": max_concurrency,
            "MaxErrors": max_errors,
            "LoggingInfo": logging_info,
            "Name": name,
            "Description": description,
            "ClientToken": client_token,
        },
    )
