"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx, window_id: str, window_task_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a task from a maintenance window.

    Args:
        window_id(str): The ID of the maintenance window the task should be removed from.
        window_task_id(str): The ID of the task to remove from the maintenance window.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.task.from_maintenance_window.deregister(
                ctx, window_id=value, window_task_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.task.from_maintenance_window.deregister window_id=value, window_task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="deregister_task_from_maintenance_window",
        op_kwargs={"WindowId": window_id, "WindowTaskId": window_task_id},
    )
