"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def register(
    hub,
    ctx,
    window_id: str,
    resource_type: str,
    targets: List,
    owner_information: str = None,
    name: str = None,
    description: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers a target with a maintenance window.

    Args:
        window_id(str): The ID of the maintenance window the target should be registered with.
        resource_type(str): The type of target being registered with the maintenance window.
        targets(List): The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs.  If a single maintenance window task is registered with multiple targets, its task invocations occur sequentially and not in parallel. If your task must run on multiple targets at the same time, register a task for each target individually and assign each task the same priority level.  You can specify targets using instance IDs, resource group names, or tags that have been applied to instances.  Example 1: Specify instance IDs  Key=InstanceIds,Values=instance-id-1,instance-id-2,instance-id-3    Example 2: Use tag key-pairs applied to instances  Key=tag:my-tag-key,Values=my-tag-value-1,my-tag-value-2    Example 3: Use tag-keys applied to instances  Key=tag-key,Values=my-tag-key-1,my-tag-key-2    Example 4: Use resource group names  Key=resource-groups:Name,Values=resource-group-name    Example 5: Use filters for resource group types  Key=resource-groups:ResourceTypeFilters,Values=resource-type-1,resource-type-2    For Key=resource-groups:ResourceTypeFilters, specify resource types in the following format  Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC    For more information about these examples formats, including the best use case for each one, see Examples: Register targets with a maintenance window in the Amazon Web Services Systems Manager User Guide.
        owner_information(str, optional): User-provided value that will be included in any Amazon CloudWatch Events events raised while running tasks for these targets in this maintenance window. Defaults to None.
        name(str, optional): An optional name for the target. Defaults to None.
        description(str, optional): An optional description for the target. Defaults to None.
        client_token(str, optional): User-provided idempotency token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.target.with_maintenance_window.register(
                ctx, window_id=value, resource_type=value, targets=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.target.with_maintenance_window.register window_id=value, resource_type=value, targets=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="register_target_with_maintenance_window",
        op_kwargs={
            "WindowId": window_id,
            "ResourceType": resource_type,
            "Targets": targets,
            "OwnerInformation": owner_information,
            "Name": name,
            "Description": description,
            "ClientToken": client_token,
        },
    )
