"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(
    hub, ctx, window_id: str, window_target_id: str, safe: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a target from a maintenance window.

    Args:
        window_id(str): The ID of the maintenance window the target should be removed from.
        window_target_id(str): The ID of the target definition to remove.
        safe(bool, optional): The system checks if the target is being referenced by a task. If the target is being referenced, the system returns an error and doesn't deregister the target from the maintenance window. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.target.from_maintenance_window.deregister(
                ctx, window_id=value, window_target_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.target.from_maintenance_window.deregister window_id=value, window_target_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="deregister_target_from_maintenance_window",
        op_kwargs={
            "WindowId": window_id,
            "WindowTargetId": window_target_id,
            "Safe": safe,
        },
    )
