"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, resource_type: str, resource_id: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your documents, managed instances, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account's managed instances that helps you track each instance's owner and stack level. For example:    Key=Owner,Value=DbAdmin     Key=Owner,Value=SysAdmin     Key=Owner,Value=Dev     Key=Stack,Value=Production     Key=Stack,Value=Pre-Production     Key=Stack,Value=Test    Each resource can have a maximum of 50 tags. We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of characters.  For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see Tagging your Amazon EC2 resources in the Amazon EC2 User Guide.

    Args:
        resource_type(str): Specifies the type of resource you are tagging.  The ManagedInstance type for this API operation is for on-premises managed instances. You must specify the name of the managed instance in the following format: mi-ID_number . For example, mi-1a2b3c4d5e6f. .
        resource_id(str): The resource ID you want to tag. Use the ID of the resource. Here are some examples:  MaintenanceWindow: mw-012345abcde   PatchBaseline: pb-012345abcde   OpsMetadata object: ResourceID for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, ResourceID is created from the strings that come after the word opsmetadata in the ARN. For example, an OpsMetadata object with an ARN of arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager has a ResourceID of either aws/ssm/MyGroup/appmanager or /aws/ssm/MyGroup/appmanager. For the Document and Parameter values, use the name of the resource.  ManagedInstance: mi-012345abcde   The ManagedInstance type for this API operation is only for on-premises managed instances. You must specify the name of the managed instance in the following format: mi-ID_number . For example, mi-1a2b3c4d5e6f. .
        tags(List): One or more tags. The value parameter is required.  Don't enter personally identifiable information in this field. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.tags.to_resource.add(
                ctx, resource_type=value, resource_id=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.tags.to_resource.add resource_type=value, resource_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="add_tags_to_resource",
        op_kwargs={
            "ResourceType": resource_type,
            "ResourceId": resource_id,
            "Tags": tags,
        },
    )
