"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def remove(
    hub, ctx, resource_type: str, resource_id: str, tag_keys: List
) -> Dict:
    r"""
    **Autogenerated function**

    Removes tag keys from the specified resource.

    Args:
        resource_type(str): The type of resource from which you want to remove a tag.  The ManagedInstance type for this API operation is only for on-premises managed instances. Specify the name of the managed instance in the following format: mi-ID_number . For example, mi-1a2b3c4d5e6f. .
        resource_id(str): The ID of the resource from which you want to remove tags. For example: ManagedInstance: mi-012345abcde MaintenanceWindow: mw-012345abcde PatchBaseline: pb-012345abcde OpsMetadata object: ResourceID for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, ResourceID is created from the strings that come after the word opsmetadata in the ARN. For example, an OpsMetadata object with an ARN of arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager has a ResourceID of either aws/ssm/MyGroup/appmanager or /aws/ssm/MyGroup/appmanager. For the Document and Parameter values, use the name of the resource.  The ManagedInstance type for this API operation is only for on-premises managed instances. Specify the name of the managed instance in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f. .
        tag_keys(List): Tag keys that you want to remove from the specified resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.tags.from_resource.remove(
                ctx, resource_type=value, resource_id=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.tags.from_resource.remove resource_type=value, resource_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="remove_tags_from_resource",
        op_kwargs={
            "ResourceType": resource_type,
            "ResourceId": resource_id,
            "TagKeys": tag_keys,
        },
    )
