"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource_type: str, resource_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the tags assigned to the specified resource. For information about the ID format for each supported resource type, see AddTagsToResource.

    Args:
        resource_type(str): Returns a list of tags for a specific resource type.
        resource_id(str): The resource ID for which you want to see a list of tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.tags.for_resource.list(
                ctx, resource_type=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.tags.for_resource.list resource_type=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_tags_for_resource",
        op_kwargs={"ResourceType": resource_type, "ResourceId": resource_id},
    )
