"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    state: str,
    max_results: int = None,
    next_token: str = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days.

    Args:
        state(str): The session status to retrieve a list of sessions for. For example, "Active".
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        filters(List, optional): One or more filters to limit the type of sessions returned by the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.session.describe_all(ctx, state=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.session.describe_all state=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_sessions",
        op_kwargs={
            "State": state,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
        },
    )


async def resume(hub, ctx, session_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Reconnects a session to an instance after it has been disconnected. Connections can be resumed for disconnected sessions, but not terminated sessions.  This command is primarily for use by client machines to automatically reconnect during intermittent network issues. It isn't intended for any other use.

    Args:
        session_id(str): The ID of the disconnected session to resume.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.session.resume(ctx, session_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.session.resume session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="resume_session",
        op_kwargs={"SessionId": session_id},
    )


async def start(
    hub, ctx, target: str, document_name: str = None, parameters: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Initiates a connection to a target (for example, an instance) for a Session Manager session. Returns a URL and token that can be used to open a WebSocket connection for sending input and receiving outputs.  Amazon Web Services CLI usage: start-session is an interactive command that requires the Session Manager plugin to be installed on the client machine making the call. For information, see Install the Session Manager plugin for the Amazon Web Services CLI in the Amazon Web Services Systems Manager User Guide. Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon Web Services Tools for PowerShell on Windows local machines.

    Args:
        target(str): The instance to connect to for the session.
        document_name(str, optional): The name of the SSM document to define the parameters and plugin settings for the session. For example, SSM-SessionManagerRunShell. You can call the GetDocument API to verify the document exists before attempting to start a session. If no document name is provided, a shell to the instance is launched by default. Defaults to None.
        parameters(Dict, optional): Reserved for future use. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.session.start(ctx, target=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.session.start target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="start_session",
        op_kwargs={
            "Target": target,
            "DocumentName": document_name,
            "Parameters": parameters,
        },
    )


async def terminate(hub, ctx, session_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the instance. A terminated session isn't be resumed.

    Args:
        session_id(str): The ID of the session to terminate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.session.terminate(ctx, session_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.session.terminate session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="terminate_session",
        op_kwargs={"SessionId": session_id},
    )
