"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def create(
    hub,
    ctx,
    sync_name: str,
    s3_destination: Dict = None,
    sync_type: str = None,
    sync_source: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems Manager offers two types of resource data sync: SyncToDestination and SyncFromSource. You can configure Systems Manager Inventory to use the SyncToDestination type to synchronize Inventory data from multiple Regions to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information, see Configuring resource data sync for Inventory in the Amazon Web Services Systems Manager User Guide. You can configure Systems Manager Explorer to use the SyncFromSource type to synchronize operational work items (OpsItems) and operational data (OpsData) from multiple Regions to a single Amazon S3 bucket. This type can synchronize OpsItems and OpsData from multiple accounts and Regions or EntireOrganization by using Organizations. For more information, see Setting up Systems Manager Explorer to display data from multiple accounts and Regions in the Amazon Web Services Systems Manager User Guide. A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data. To check the status of a sync, use the ListResourceDataSync.  By default, data isn't encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy.

    Args:
        sync_name(str): A name for the configuration.
        s3_destination(Dict, optional): Amazon S3 configuration details for the sync. This parameter is required if the SyncType value is SyncToDestination. Defaults to None.
        sync_type(str, optional): Specify SyncToDestination to create a resource data sync that synchronizes data to an S3 bucket for Inventory. If you specify SyncToDestination, you must provide a value for S3Destination. Specify SyncFromSource to synchronize data from a single account and multiple Regions, or multiple accounts and Regions, as listed in Organizations for Explorer. If you specify SyncFromSource, you must provide a value for SyncSource. The default value is SyncToDestination. Defaults to None.
        sync_source(Dict, optional): Specify information about the data sources to synchronize. This parameter is required if the SyncType value is SyncFromSource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.resource.data_sync.create(ctx, sync_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.resource.data_sync.create sync_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_resource_data_sync",
        op_kwargs={
            "SyncName": sync_name,
            "S3Destination": s3_destination,
            "SyncType": sync_type,
            "SyncSource": sync_source,
        },
    )


async def delete(hub, ctx, sync_name: str, sync_type: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a resource data sync configuration. After the configuration is deleted, changes to data on managed instances are no longer synced to or from the target. Deleting a sync configuration doesn't delete data.

    Args:
        sync_name(str): The name of the configuration to delete.
        sync_type(str, optional): Specify the type of resource data sync to delete. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.resource.data_sync.delete(ctx, sync_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.resource.data_sync.delete sync_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_resource_data_sync",
        op_kwargs={"SyncName": sync_name, "SyncType": sync_type},
    )


async def list_(
    hub, ctx, sync_type: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your resource data sync configurations. Includes information about the last time a sync attempted to start, the last sync status, and the last time a sync successfully completed. The number of sync configurations might be too large to return using a single call to ListResourceDataSync. You can limit the number of sync configurations returned by using the MaxResults parameter. To determine whether there are more sync configurations to list, check the value of NextToken in the output. If there are more sync configurations to list, you can request them by specifying the NextToken returned in the call to the parameter of a subsequent call.

    Args:
        sync_type(str, optional): View a list of resource data syncs according to the sync type. Specify SyncToDestination to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify SyncFromSource to view resource data syncs from Organizations or from multiple Regions. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.resource.data_sync.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.resource.data_sync.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_resource_data_sync",
        op_kwargs={
            "SyncType": sync_type,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(hub, ctx, sync_name: str, sync_type: str, sync_source: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Update a resource data sync. After you create a resource data sync for a Region, you can't change the account options for that sync. For example, if you create a sync in the us-east-2 (Ohio) Region and you choose the Include only the current account option, you can't edit that sync later and choose the Include all accounts from my Organizations configuration option. Instead, you must delete the first resource data sync, and create a new one.  This API operation only supports a resource data sync that was created with a SyncFromSource SyncType.

    Args:
        sync_name(str): The name of the resource data sync you want to update.
        sync_type(str): The type of resource data sync. The supported SyncType is SyncFromSource.
        sync_source(Dict): Specify information about the data sources to synchronize.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.resource.data_sync.update(
                ctx, sync_name=value, sync_type=value, sync_source=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.resource.data_sync.update sync_name=value, sync_type=value, sync_source=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_resource_data_sync",
        op_kwargs={
            "SyncName": sync_name,
            "SyncType": sync_type,
            "SyncSource": sync_source,
        },
    )
