"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, patch_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns high-level aggregated patch compliance state information for a patch group.

    Args:
        patch_group(str): The name of the patch group whose patch snapshot should be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.group.state.describe(ctx, patch_group=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.group.state.describe patch_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_patch_group_state",
        op_kwargs={"PatchGroup": patch_group},
    )
