"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    operating_system: str = None,
    global_filters: Dict = None,
    approval_rules: Dict = None,
    approved_patches: List = None,
    approved_patches_compliance_level: str = None,
    approved_patches_enable_non_security: bool = None,
    rejected_patches: List = None,
    rejected_patches_action: str = None,
    description: str = None,
    sources: List = None,
    client_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a patch baseline.  For information about valid key-value pairs in PatchFilters for each supported operating system type, see PatchFilter.

    Args:
        operating_system(str, optional): Defines the operating system the patch baseline applies to. The default value is WINDOWS. Defaults to None.
        name(str): The name of the patch baseline.
        global_filters(Dict, optional): A set of global filters used to include patches in the baseline. Defaults to None.
        approval_rules(Dict, optional): A set of rules used to include patches in the baseline. Defaults to None.
        approved_patches(List, optional): A list of explicitly approved patches for the baseline. For information about accepted formats for lists of approved patches and rejected patches, see About package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        approved_patches_compliance_level(str, optional): Defines the compliance level for approved patches. When an approved patch is reported as missing, this value describes the severity of the compliance violation. The default value is UNSPECIFIED. Defaults to None.
        approved_patches_enable_non_security(bool, optional): Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is false. Applies to Linux instances only. Defaults to None.
        rejected_patches(List, optional): A list of explicitly rejected patches for the baseline. For information about accepted formats for lists of approved patches and rejected patches, see About package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        rejected_patches_action(str, optional): The action for Patch Manager to take on patches included in the RejectedPackages list.     ALLOW_AS_DEPENDENCY : A package in the Rejected patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as InstalledOther. This is the default action if no option is specified.     BLOCK : Packages in the RejectedPatches list, and packages that include them as dependencies, aren't installed under any circumstances. If a package was installed before it was added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as InstalledRejected.  . Defaults to None.
        description(str, optional): A description of the patch baseline. Defaults to None.
        sources(List, optional): Information about the patches to use to update the instances, including target operating systems and source repositories. Applies to Linux instances only. Defaults to None.
        client_token(str, optional): User-provided idempotency token. Defaults to None.
        tags(List, optional): Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify the severity level of patches it specifies and the operating system family it applies to. In this case, you could specify the following key-value pairs:    Key=PatchSeverity,Value=Critical     Key=OS,Value=Windows     To add tags to an existing patch baseline, use the AddTagsToResource operation. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.baseline.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.baseline.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_patch_baseline",
        op_kwargs={
            "OperatingSystem": operating_system,
            "Name": name,
            "GlobalFilters": global_filters,
            "ApprovalRules": approval_rules,
            "ApprovedPatches": approved_patches,
            "ApprovedPatchesComplianceLevel": approved_patches_compliance_level,
            "ApprovedPatchesEnableNonSecurity": approved_patches_enable_non_security,
            "RejectedPatches": rejected_patches,
            "RejectedPatchesAction": rejected_patches_action,
            "Description": description,
            "Sources": sources,
            "ClientToken": client_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, baseline_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a patch baseline.

    Args:
        baseline_id(str): The ID of the patch baseline to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.baseline.init.delete(ctx, baseline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.baseline.init.delete baseline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_patch_baseline",
        op_kwargs={"BaselineId": baseline_id},
    )


async def describe_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the patch baselines in your account.

    Args:
        filters(List, optional): Each element in the array is a structure containing a key-value pair. Supported keys for DescribePatchBaselines include the following:     NAME_PREFIX   Sample values: AWS- | My-      OWNER   Sample values: AWS | Self      OPERATING_SYSTEM   Sample values: AMAZON_LINUX | SUSE | WINDOWS   . Defaults to None.
        max_results(int, optional): The maximum number of patch baselines to return (per page). Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.baseline.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.baseline.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_patch_baselines",
        op_kwargs={
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def get(hub, ctx, baseline_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a patch baseline.

    Args:
        baseline_id(str): The ID of the patch baseline to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.baseline.init.get(ctx, baseline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.baseline.init.get baseline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_patch_baseline",
        op_kwargs={"BaselineId": baseline_id},
    )


async def update(
    hub,
    ctx,
    baseline_id: str,
    name: str = None,
    global_filters: Dict = None,
    approval_rules: Dict = None,
    approved_patches: List = None,
    approved_patches_compliance_level: str = None,
    approved_patches_enable_non_security: bool = None,
    rejected_patches: List = None,
    rejected_patches_action: str = None,
    description: str = None,
    sources: List = None,
    replace: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an existing patch baseline. Fields not specified in the request are left unchanged.  For information about valid key-value pairs in PatchFilters for each supported operating system type, see PatchFilter.

    Args:
        baseline_id(str): The ID of the patch baseline to update.
        name(str, optional): The name of the patch baseline. Defaults to None.
        global_filters(Dict, optional): A set of global filters used to include patches in the baseline. Defaults to None.
        approval_rules(Dict, optional): A set of rules used to include patches in the baseline. Defaults to None.
        approved_patches(List, optional): A list of explicitly approved patches for the baseline. For information about accepted formats for lists of approved patches and rejected patches, see About package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        approved_patches_compliance_level(str, optional): Assigns a new compliance severity level to an existing patch baseline. Defaults to None.
        approved_patches_enable_non_security(bool, optional): Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is false. Applies to Linux instances only. Defaults to None.
        rejected_patches(List, optional): A list of explicitly rejected patches for the baseline. For information about accepted formats for lists of approved patches and rejected patches, see About package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        rejected_patches_action(str, optional): The action for Patch Manager to take on patches included in the RejectedPackages list.     ALLOW_AS_DEPENDENCY : A package in the Rejected patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as InstalledOther. This is the default action if no option is specified.     BLOCK : Packages in the RejectedPatches list, and packages that include them as dependencies, aren't installed under any circumstances. If a package was installed before it was added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as InstalledRejected.  . Defaults to None.
        description(str, optional): A description of the patch baseline. Defaults to None.
        sources(List, optional): Information about the patches to use to update the instances, including target operating systems and source repositories. Applies to Linux instances only. Defaults to None.
        replace(bool, optional): If True, then all fields that are required by the CreatePatchBaseline operation are also required for this API request. Optional fields that aren't specified are set to null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.baseline.init.update(ctx, baseline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.baseline.init.update baseline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_patch_baseline",
        op_kwargs={
            "BaselineId": baseline_id,
            "Name": name,
            "GlobalFilters": global_filters,
            "ApprovalRules": approval_rules,
            "ApprovedPatches": approved_patches,
            "ApprovedPatchesComplianceLevel": approved_patches_compliance_level,
            "ApprovedPatchesEnableNonSecurity": approved_patches_enable_non_security,
            "RejectedPatches": rejected_patches,
            "RejectedPatchesAction": rejected_patches_action,
            "Description": description,
            "Sources": sources,
            "Replace": replace,
        },
    )
