"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx, baseline_id: str, patch_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a patch group from a patch baseline.

    Args:
        baseline_id(str): The ID of the patch baseline to deregister the patch group from.
        patch_group(str): The name of the patch group that should be deregistered from the patch baseline.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.baseline.for_patch_group.deregister(
                ctx, baseline_id=value, patch_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.baseline.for_patch_group.deregister baseline_id=value, patch_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="deregister_patch_baseline_for_patch_group",
        op_kwargs={"BaselineId": baseline_id, "PatchGroup": patch_group},
    )


async def get(hub, ctx, patch_group: str, operating_system: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the patch baseline that should be used for the specified patch group.

    Args:
        patch_group(str): The name of the patch group whose patch baseline should be retrieved.
        operating_system(str, optional): Returns he operating system rule specified for patch groups using the patch baseline. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.baseline.for_patch_group.get(ctx, patch_group=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.baseline.for_patch_group.get patch_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_patch_baseline_for_patch_group",
        op_kwargs={"PatchGroup": patch_group, "OperatingSystem": operating_system},
    )


async def register(hub, ctx, baseline_id: str, patch_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Registers a patch baseline for a patch group.

    Args:
        baseline_id(str): The ID of the patch baseline to register with the patch group.
        patch_group(str): The name of the patch group to be registered with the patch baseline.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.patch.baseline.for_patch_group.register(
                ctx, baseline_id=value, patch_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.patch.baseline.for_patch_group.register baseline_id=value, patch_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="register_patch_baseline_for_patch_group",
        op_kwargs={"BaselineId": baseline_id, "PatchGroup": patch_group},
    )
