"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def label(
    hub, ctx, name: str, labels: List, parameter_version: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version number by one. A label can help you remember the purpose of a parameter when there are multiple versions.  Parameter labels have the following requirements and restrictions.   A version of a parameter can have a maximum of 10 labels.   You can't attach the same label to different versions of the same parameter. For example, if version 1 has the label Production, then you can't attach Production to version 2.   You can move a label from one version of a parameter to another.   You can't create a label when you create a new parameter. You must attach a label to a specific version of a parameter.   If you no longer want to use a parameter label, then you can either delete it or move it to a different version of a parameter.   A label can have a maximum of 100 characters.   Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).   Labels can't begin with a number, "aws" or "ssm" (not case sensitive). If a label fails to meet these requirements, then the label isn't associated with a parameter and the system displays it in the list of InvalidLabels.

    Args:
        name(str): The parameter name on which you want to attach one or more labels.
        parameter_version(int, optional): The specific version of the parameter on which you want to attach one or more labels. If no version is specified, the system attaches the label to the latest version. Defaults to None.
        labels(List): One or more labels to attach to the specified parameter version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.version.label(ctx, name=value, labels=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.version.label name=value, labels=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="label_parameter_version",
        op_kwargs={
            "Name": name,
            "ParameterVersion": parameter_version,
            "Labels": labels,
        },
    )


async def unlabel(hub, ctx, name: str, parameter_version: int, labels: List) -> Dict:
    r"""
    **Autogenerated function**

    Remove a label or labels from a parameter.

    Args:
        name(str): The name of the parameter from which you want to delete one or more labels.
        parameter_version(int): The specific version of the parameter which you want to delete one or more labels from. If it isn't present, the call will fail.
        labels(List): One or more labels to delete from the specified parameter version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.version.unlabel(
                ctx, name=value, parameter_version=value, labels=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.version.unlabel name=value, parameter_version=value, labels=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="unlabel_parameter_version",
        op_kwargs={
            "Name": name,
            "ParameterVersion": parameter_version,
            "Labels": labels,
        },
    )
