"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete a parameter from the system.

    Args:
        name(str): The name of the parameter to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ssm", operation="delete_parameter", op_kwargs={"Name": name}
    )


async def delete_multiple(hub, ctx, names: List) -> Dict:
    r"""
    **Autogenerated function**

    Delete a list of parameters.

    Args:
        names(List): The names of the parameters to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.init.delete_multiple(ctx, names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.init.delete_multiple names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_parameters",
        op_kwargs={"Names": names},
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    parameter_filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get information about a parameter. Request results are returned on a best-effort basis. If you specify MaxResults in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of MaxResults. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a NextToken. You can specify the NextToken in a subsequent call to get the next set of results.

    Args:
        filters(List, optional): This data type is deprecated. Instead, use ParameterFilters. Defaults to None.
        parameter_filters(List, optional): Filters to limit the request results. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_parameters",
        op_kwargs={
            "Filters": filters,
            "ParameterFilters": parameter_filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def get(hub, ctx, name: str, with_decryption: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Get information about a parameter by using the parameter name. Don't confuse this API operation with the GetParameters API operation.

    Args:
        name(str): The name of the parameter you want to query.
        with_decryption(bool, optional): Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_parameter",
        op_kwargs={"Name": name, "WithDecryption": with_decryption},
    )


async def get_all(hub, ctx, names: List, with_decryption: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Get details of a parameter. Don't confuse this API operation with the GetParameter API operation.

    Args:
        names(List): Names of the parameters for which you want to query information.
        with_decryption(bool, optional): Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.init.get_all(ctx, names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.init.get_all names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_parameters",
        op_kwargs={"Names": names, "WithDecryption": with_decryption},
    )


async def put(
    hub,
    ctx,
    name: str,
    value: str,
    description: str = None,
    type_: str = None,
    key_id: str = None,
    overwrite: bool = None,
    allowed_pattern: str = None,
    tags: List = None,
    tier: str = None,
    policies: str = None,
    data_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Add a parameter to the system.

    Args:
        name(str): The fully qualified name of the parameter that you want to add to the system. The fully qualified name includes the complete hierarchy of the parameter path and name. For parameters in a hierarchy, you must include a leading forward slash character (/) when you create or reference a parameter. For example: /Dev/DBServer/MySQL/db-string13  Naming Constraints:   Parameter names are case sensitive.   A parameter name must be unique within an Region   A parameter name can't be prefixed with "aws" or "ssm" (case-insensitive).   Parameter names can include only the following symbols and letters: a-zA-Z0-9_.-  In addition, the slash character ( / ) is used to delineate hierarchies in parameter names. For example: /Dev/Production/East/Project-ABC/MyParameter    A parameter name can't include spaces.   Parameter hierarchies are limited to a maximum depth of fifteen levels.   For additional information about valid values for parameter names, see Creating Systems Manager parameters in the Amazon Web Services Systems Manager User Guide.  The maximum length constraint listed below includes capacity for additional system attributes that aren't part of the name. The maximum length for a parameter name, including the full length of the parameter ARN, is 1011 characters. For example, the length of the following parameter name is 65 characters, not 20 characters:  arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName  .
        description(str, optional): Information about the parameter that you want to add to the system. Optional but recommended.  Don't enter personally identifiable information in this field. . Defaults to None.
        value(str): The parameter value that you want to add to the system. Standard parameters have a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.  Parameters can't be referenced or nested in the values of other parameters. You can't include {{}} or {{ssm:parameter-name}} in a parameter value. .
        type_(str, optional): The type of parameter that you want to add to the system.   SecureString isn't currently supported for CloudFormation templates.  Items in a StringList must be separated by a comma (,). You can't use other punctuation or special character to escape items in the list. If you have a parameter value that requires a comma, then use the String data type.  Specifying a parameter type isn't required when updating a parameter. You must specify a parameter type when creating a parameter. . Defaults to None.
        key_id(str, optional): The Key Management Service (KMS) ID that you want to use to encrypt a parameter. Either the default KMS key automatically assigned to your account or a custom key. Required for parameters that use the SecureString data type. If you don't specify a key ID, the system uses the default key associated with your account.   To use your default KMS key, choose the SecureString data type, and do not specify the Key ID when you create the parameter. The system automatically populates Key ID with your default KMS key.   To use a custom KMS key, choose the SecureString data type with the Key ID parameter.  . Defaults to None.
        overwrite(bool, optional): Overwrite an existing parameter. The default value is false. Defaults to None.
        allowed_pattern(str, optional): A regular expression used to validate the parameter value. For example, for String types with values restricted to numbers, you can specify the following: AllowedPattern=^\d+$ . Defaults to None.
        tags(List, optional): Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a Systems Manager parameter to identify the type of resource to which it applies, the environment, or the type of configuration data referenced by the parameter. In this case, you could specify the following key-value pairs:    Key=Resource,Value=S3bucket     Key=OS,Value=Windows     Key=ParameterType,Value=LicenseKey     To add tags to an existing Systems Manager parameter, use the AddTagsToResource operation. . Defaults to None.
        tier(str, optional): The parameter tier to assign to a parameter. Parameter Store offers a standard tier and an advanced tier for parameters. Standard parameters have a content size limit of 4 KB and can't be configured to use parameter policies. You can create a maximum of 10,000 standard parameters for each Region in an account. Standard parameters are offered at no additional cost.  Advanced parameters have a content size limit of 8 KB and can be configured to use parameter policies. You can create a maximum of 100,000 advanced parameters for each Region in an account. Advanced parameters incur a charge. For more information, see Standard and advanced parameter tiers in the Amazon Web Services Systems Manager User Guide. You can change a standard parameter to an advanced parameter any time. But you can't revert an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard parameter would result in data loss because the system would truncate the size of the parameter from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly, advanced parameters use a different form of encryption than standard parameters.  If you no longer need an advanced parameter, or if you no longer want to incur charges for an advanced parameter, you must delete it and recreate it as a new standard parameter.   Using the Default Tier Configuration  In PutParameter requests, you can specify the tier to create the parameter in. Whenever you specify a tier in the request, Parameter Store creates or updates the parameter according to that request. However, if you don't specify a tier in a request, Parameter Store assigns the tier based on the current Parameter Store default tier configuration. The default tier when you begin using Parameter Store is the standard-parameter tier. If you use the advanced-parameter tier, you can specify one of the following as the default:    Advanced: With this option, Parameter Store evaluates all requests as advanced parameters.     Intelligent-Tiering: With this option, Parameter Store evaluates each request to determine if the parameter is standard or advanced.  If the request doesn't include any options that require an advanced parameter, the parameter is created in the standard-parameter tier. If one or more options requiring an advanced parameter are included in the request, Parameter Store create a parameter in the advanced-parameter tier. This approach helps control your parameter-related costs by always creating standard parameters unless an advanced parameter is necessary.    Options that require an advanced parameter include the following:   The content size of the parameter is more than 4 KB.   The parameter uses a parameter policy.   More than 10,000 parameters already exist in your account in the current Region.   For more information about configuring the default tier option, see Specifying a default parameter tier in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        policies(str, optional): One or more policies to apply to a parameter. This operation takes a JSON array. Parameter Store, a capability of Amazon Web Services Systems Manager supports the following policy types: Expiration: This policy deletes the parameter after it expires. When you create the policy, you specify the expiration date. You can update the expiration date and time by updating the policy. Updating the parameter doesn't affect the expiration date and time. When the expiration time is reached, Parameter Store deletes the parameter. ExpirationNotification: This policy triggers an event in Amazon CloudWatch Events that notifies you about the expiration. By using this policy, you can receive notification before or after the expiration time is reached, in units of days or hours. NoChangeNotification: This policy triggers a CloudWatch Events event if a parameter hasn't been modified for a specified period of time. This policy type is useful when, for example, a secret needs to be changed within a period of time, but it hasn't been changed. All existing policies are preserved until you send new policies or an empty policy. For more information about parameter policies, see Assigning parameter policies. . Defaults to None.
        data_type(str, optional): The data type for a String parameter. Supported data types include plain text and Amazon Machine Image (AMI) IDs.  The following data type values are supported.     text     aws:ec2:image    When you create a String parameter and specify aws:ec2:image, Amazon Web Services Systems Manager validates the parameter value is in the required format, such as ami-12345abcdeEXAMPLE, and that the specified AMI is available in your account. For more information, see Native parameter support for Amazon Machine Image (AMI) IDs in the Amazon Web Services Systems Manager User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.init.put(ctx, name=value, value=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.init.put name=value, value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="put_parameter",
        op_kwargs={
            "Name": name,
            "Description": description,
            "Value": value,
            "Type": type_,
            "KeyId": key_id,
            "Overwrite": overwrite,
            "AllowedPattern": allowed_pattern,
            "Tags": tags,
            "Tier": tier,
            "Policies": policies,
            "DataType": data_type,
        },
    )
