"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    name: str,
    with_decryption: bool = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the history of all changes to a parameter.

    Args:
        name(str): The name of the parameter for which you want to review history.
        with_decryption(bool, optional): Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.parameter.history.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.parameter.history.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_parameter_history",
        op_kwargs={
            "Name": name,
            "WithDecryption": with_decryption,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
