"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    sync_name: str = None,
    filters: List = None,
    aggregators: List = None,
    result_attributes: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager Explorer.

    Args:
        sync_name(str, optional): Specify the name of a resource data sync to get. Defaults to None.
        filters(List, optional): Optional filters used to scope down the returned OpsData. . Defaults to None.
        aggregators(List, optional): Optional aggregators that return counts of OpsData based on one or more expressions. Defaults to None.
        result_attributes(List, optional): The OpsData data type to return. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.summary.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.summary.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_ops_summary",
        op_kwargs={
            "SyncName": sync_name,
            "Filters": filters,
            "Aggregators": aggregators,
            "ResultAttributes": result_attributes,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
