"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def create(
    hub, ctx, resource_id: str, metadata: Dict = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify information about the new application, including the application type.

    Args:
        resource_id(str): A resource ID for a new Application Manager application.
        metadata(Dict, optional): Metadata for a new Application Manager application. . Defaults to None.
        tags(List, optional): Optional metadata that you assign to a resource. You can specify a maximum of five tags for an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to identify an environment or target Region. In this case, you could specify the following key-value pairs:    Key=Environment,Value=Production     Key=Region,Value=us-east-2   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.metadata.create(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.metadata.create resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_ops_metadata",
        op_kwargs={"ResourceId": resource_id, "Metadata": metadata, "Tags": tags},
    )


async def delete(hub, ctx, ops_metadata_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete OpsMetadata related to an application.

    Args:
        ops_metadata_arn(str): The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.metadata.delete(ctx, ops_metadata_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.metadata.delete ops_metadata_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_ops_metadata",
        op_kwargs={"OpsMetadataArn": ops_metadata_arn},
    )


async def get(
    hub, ctx, ops_metadata_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    View operational metadata related to an application in Application Manager.

    Args:
        ops_metadata_arn(str): The Amazon Resource Name (ARN) of an OpsMetadata Object to view.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.metadata.get(ctx, ops_metadata_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.metadata.get ops_metadata_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_ops_metadata",
        op_kwargs={
            "OpsMetadataArn": ops_metadata_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def list_(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or blobs.

    Args:
        filters(List, optional): One or more filters to limit the number of OpsMetadata objects returned by the call. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.metadata.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.metadata.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_ops_metadata",
        op_kwargs={
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    ops_metadata_arn: str,
    metadata_to_update: Dict = None,
    keys_to_delete: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.

    Args:
        ops_metadata_arn(str): The Amazon Resoure Name (ARN) of the OpsMetadata Object to update.
        metadata_to_update(Dict, optional): Metadata to add to an OpsMetadata object. Defaults to None.
        keys_to_delete(List, optional): The metadata keys to delete from the OpsMetadata object. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.metadata.update(ctx, ops_metadata_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.metadata.update ops_metadata_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_ops_metadata",
        op_kwargs={
            "OpsMetadataArn": ops_metadata_arn,
            "MetadataToUpdate": metadata_to_update,
            "KeysToDelete": keys_to_delete,
        },
    )
