"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    ops_item_id: str,
    association_type: str,
    resource_type: str,
    resource_uri: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a related resource to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident Manager incident or analysis with an OpsItem. Incident Manager is a capability of Amazon Web Services Systems Manager.

    Args:
        ops_item_id(str): The ID of the OpsItem to which you want to associate a resource as a related item.
        association_type(str): The type of association that you want to create between an OpsItem and a resource. OpsCenter supports IsParentOf and RelatesTo association types.
        resource_type(str): The type of resource that you want to associate with an OpsItem. OpsCenter supports the following types:  AWS::SSMIncidents::IncidentRecord: an Incident Manager incident. Incident Manager is a capability of Amazon Web Services Systems Manager.  AWS::SSM::Document: a Systems Manager (SSM) document.
        resource_uri(str): The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the OpsItem.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.item.related_item.associate(
                ctx,
                ops_item_id=value,
                association_type=value,
                resource_type=value,
                resource_uri=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.item.related_item.associate ops_item_id=value, association_type=value, resource_type=value, resource_uri=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="associate_ops_item_related_item",
        op_kwargs={
            "OpsItemId": ops_item_id,
            "AssociationType": association_type,
            "ResourceType": resource_type,
            "ResourceUri": resource_uri,
        },
    )


async def disassociate(hub, ctx, ops_item_id: str, association_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the association between an OpsItem and a related resource. For example, this API operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a capability of Amazon Web Services Systems Manager.

    Args:
        ops_item_id(str): The ID of the OpsItem for which you want to delete an association between the OpsItem and a related resource.
        association_id(str): The ID of the association for which you want to delete an association between the OpsItem and a related resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.item.related_item.disassociate(
                ctx, ops_item_id=value, association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.item.related_item.disassociate ops_item_id=value, association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="disassociate_ops_item_related_item",
        op_kwargs={"OpsItemId": ops_item_id, "AssociationId": association_id},
    )


async def list_all(
    hub,
    ctx,
    ops_item_id: str = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all related-item resources associated with an OpsItem.

    Args:
        ops_item_id(str, optional): The ID of the OpsItem for which you want to list all related-item resources. Defaults to None.
        filters(List, optional): One or more OpsItem filters. Use a filter to return a more specific list of results. . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.item.related_item.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.item.related_item.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_ops_item_related_items",
        op_kwargs={
            "OpsItemId": ops_item_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
