"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    description: str,
    source: str,
    title: str,
    ops_item_type: str = None,
    operational_data: Dict = None,
    notifications: List = None,
    priority: int = None,
    related_ops_items: List = None,
    tags: List = None,
    category: str = None,
    severity: str = None,
    actual_start_time: str = None,
    actual_end_time: str = None,
    planned_start_time: str = None,
    planned_end_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see Getting started with OpsCenter in the Amazon Web Services Systems Manager User Guide. Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see Amazon Web Services Systems Manager OpsCenter in the Amazon Web Services Systems Manager User Guide.

    Args:
        description(str): Information about the OpsItem. .
        ops_item_type(str, optional): The type of OpsItem to create. Currently, the only valid values are /aws/changerequest and /aws/issue. Defaults to None.
        operational_data(Dict, optional): Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.  Operational data keys can't begin with the following: amazon, aws, amzn, ssm, /amazon, /aws, /amzn, /ssm.  You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the DescribeOpsItems API operation) can view and search on the specified data. Operational data that isn't searchable is only viewable by users who have access to the OpsItem (as provided by the GetOpsItem API operation). Use the /aws/resources key in OperationalData to specify a related resource in the request. Use the /aws/automations key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see Creating OpsItems manually in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        notifications(List, optional): The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed. Defaults to None.
        priority(int, optional): The importance of this OpsItem in relation to other OpsItems in the system. Defaults to None.
        related_ops_items(List, optional): One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource. Defaults to None.
        source(str): The origin of the OpsItem, such as Amazon EC2 or Systems Manager.  The source name can't contain the following strings: aws, amazon, and amzn.  .
        title(str): A short heading that describes the nature of the OpsItem and the impacted resource.
        tags(List, optional): Optional metadata that you assign to a resource. You can restrict access to OpsItems by using an inline IAM policy that specifies tags. For more information, see Getting started with OpsCenter in the Amazon Web Services Systems Manager User Guide. Tags use a key-value pair. For example:  Key=Department,Value=Finance   To add tags to a new OpsItem, a user must have IAM permissions for both the ssm:CreateOpsItems operation and the ssm:AddTagsToResource operation. To add tags to an existing OpsItem, use the AddTagsToResource operation. . Defaults to None.
        category(str, optional): Specify a category to assign to an OpsItem. . Defaults to None.
        severity(str, optional): Specify a severity to assign to an OpsItem. Defaults to None.
        actual_start_time(str, optional): The time a runbook workflow started. Currently reported only for the OpsItem type /aws/changerequest. Defaults to None.
        actual_end_time(str, optional): The time a runbook workflow ended. Currently reported only for the OpsItem type /aws/changerequest. Defaults to None.
        planned_start_time(str, optional): The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type /aws/changerequest. Defaults to None.
        planned_end_time(str, optional): The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type /aws/changerequest. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.item.init.create(
                ctx, description=value, source=value, title=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.item.init.create description=value, source=value, title=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_ops_item",
        op_kwargs={
            "Description": description,
            "OpsItemType": ops_item_type,
            "OperationalData": operational_data,
            "Notifications": notifications,
            "Priority": priority,
            "RelatedOpsItems": related_ops_items,
            "Source": source,
            "Title": title,
            "Tags": tags,
            "Category": category,
            "Severity": severity,
            "ActualStartTime": actual_start_time,
            "ActualEndTime": actual_end_time,
            "PlannedStartTime": planned_start_time,
            "PlannedEndTime": planned_end_time,
        },
    )


async def describe_all(
    hub,
    ctx,
    ops_item_filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see Getting started with OpsCenter in the Amazon Web Services Systems Manager User Guide. Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see OpsCenter in the Amazon Web Services Systems Manager User Guide.

    Args:
        ops_item_filters(List, optional): One or more filters to limit the response.   Key: CreatedTime Operations: GreaterThan, LessThan   Key: LastModifiedBy Operations: Contains, Equals   Key: LastModifiedTime Operations: GreaterThan, LessThan   Key: Priority Operations: Equals   Key: Source Operations: Contains, Equals   Key: Status Operations: Equals   Key: Title* Operations: Equals,Contains   Key: OperationalData** Operations: Equals   Key: OperationalDataKey Operations: Equals   Key: OperationalDataValue Operations: Equals, Contains   Key: OpsItemId Operations: Equals   Key: ResourceId Operations: Contains   Key: AutomationId Operations: Equals   *The Equals operator for Title matches the first 100 characters. If you specify more than 100 characters, they system returns an error that the filter value exceeds the length limit. **If you filter the response by using the OperationalData operator, specify a key-value pair by using the following JSON format: {"key":"key_name","value":"a_value"}. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.item.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.item.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_ops_items",
        op_kwargs={
            "OpsItemFilters": ops_item_filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def get(hub, ctx, ops_item_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information, see Getting started with OpsCenter in the Amazon Web Services Systems Manager User Guide. Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see OpsCenter in the Amazon Web Services Systems Manager User Guide.

    Args:
        ops_item_id(str): The ID of the OpsItem that you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.item.init.get(ctx, ops_item_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.item.init.get ops_item_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_ops_item",
        op_kwargs={"OpsItemId": ops_item_id},
    )


async def update(
    hub,
    ctx,
    ops_item_id: str,
    description: str = None,
    operational_data: Dict = None,
    operational_data_to_delete: List = None,
    notifications: List = None,
    priority: int = None,
    related_ops_items: List = None,
    status: str = None,
    title: str = None,
    category: str = None,
    severity: str = None,
    actual_start_time: str = None,
    actual_end_time: str = None,
    planned_start_time: str = None,
    planned_end_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem. For more information, see Getting started with OpsCenter in the Amazon Web Services Systems Manager User Guide. Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see OpsCenter in the Amazon Web Services Systems Manager User Guide.

    Args:
        description(str, optional): Update the information about the OpsItem. Provide enough information so that users reading this OpsItem for the first time understand the issue. . Defaults to None.
        operational_data(Dict, optional): Add new keys or edit existing key-value pairs of the OperationalData map in the OpsItem object. Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.  Operational data keys can't begin with the following: amazon, aws, amzn, ssm, /amazon, /aws, /amzn, /ssm.  You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the DescribeOpsItems API operation) can view and search on the specified data. Operational data that isn't searchable is only viewable by users who have access to the OpsItem (as provided by the GetOpsItem API operation). Use the /aws/resources key in OperationalData to specify a related resource in the request. Use the /aws/automations key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see Creating OpsItems manually in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        operational_data_to_delete(List, optional): Keys that you want to remove from the OperationalData map. Defaults to None.
        notifications(List, optional): The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed. Defaults to None.
        priority(int, optional): The importance of this OpsItem in relation to other OpsItems in the system. Defaults to None.
        related_ops_items(List, optional): One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource. Defaults to None.
        status(str, optional): The OpsItem status. Status can be Open, In Progress, or Resolved. For more information, see Editing OpsItem details in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        ops_item_id(str): The ID of the OpsItem.
        title(str, optional): A short heading that describes the nature of the OpsItem and the impacted resource. Defaults to None.
        category(str, optional): Specify a new category for an OpsItem. Defaults to None.
        severity(str, optional): Specify a new severity for an OpsItem. Defaults to None.
        actual_start_time(str, optional): The time a runbook workflow started. Currently reported only for the OpsItem type /aws/changerequest. Defaults to None.
        actual_end_time(str, optional): The time a runbook workflow ended. Currently reported only for the OpsItem type /aws/changerequest. Defaults to None.
        planned_start_time(str, optional): The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type /aws/changerequest. Defaults to None.
        planned_end_time(str, optional): The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type /aws/changerequest. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.ops.item.init.update(ctx, ops_item_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.ops.item.init.update ops_item_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_ops_item",
        op_kwargs={
            "Description": description,
            "OperationalData": operational_data,
            "OperationalDataToDelete": operational_data_to_delete,
            "Notifications": notifications,
            "Priority": priority,
            "RelatedOpsItems": related_ops_items,
            "Status": status,
            "OpsItemId": ops_item_id,
            "Title": title,
            "Category": category,
            "Severity": severity,
            "ActualStartTime": actual_start_time,
            "ActualEndTime": actual_end_time,
            "PlannedStartTime": planned_start_time,
            "PlannedEndTime": planned_end_time,
        },
    )
