"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, instance_id: str, iam_role: str) -> Dict:
    r"""
    **Autogenerated function**

    Changes the Identity and Access Management (IAM) role that is assigned to the on-premises instance or virtual machines (VM). IAM roles are first assigned to these hybrid instances during the activation process. For more information, see CreateActivation.

    Args:
        instance_id(str): The ID of the managed instance where you want to update the role.
        iam_role(str): The IAM role you want to assign or change.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.managed_instance.role.update(
                ctx, instance_id=value, iam_role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.managed_instance.role.update instance_id=value, iam_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_managed_instance_role",
        op_kwargs={"InstanceId": instance_id, "IamRole": iam_role},
    )
