"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx, instance_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the server or virtual machine from the list of registered servers. You can reregister the instance again at any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.

    Args:
        instance_id(str): The ID assigned to the managed instance when you registered it using the activation process. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.managed_instance.init.deregister(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.managed_instance.init.deregister instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="deregister_managed_instance",
        op_kwargs={"InstanceId": instance_id},
    )
