"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    window_id: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the targets registered with the maintenance window.

    Args:
        window_id(str): The ID of the maintenance window whose targets should be retrieved.
        filters(List, optional): Optional filters that can be used to narrow down the scope of the returned window targets. The supported filter keys are Type, WindowTargetId, and OwnerInformation. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.target.describe_all(ctx, window_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.target.describe_all window_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_maintenance_window_targets",
        op_kwargs={
            "WindowId": window_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    window_id: str,
    window_target_id: str,
    targets: List = None,
    owner_information: str = None,
    name: str = None,
    description: str = None,
    replace: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the target of an existing maintenance window. You can change the following:   Name   Description   Owner   IDs for an ID target   Tags for a Tag target   From any supported tag type to another. The three supported tag types are ID target, Tag target, and resource group. For more information, see Target.    If a parameter is null, then the corresponding field isn't modified.

    Args:
        window_id(str): The maintenance window ID with which to modify the target.
        window_target_id(str): The target ID to modify.
        targets(List, optional): The targets to add or replace. Defaults to None.
        owner_information(str, optional): User-provided value that will be included in any Amazon CloudWatch Events events raised while running tasks for these targets in this maintenance window. Defaults to None.
        name(str, optional): A name for the update. Defaults to None.
        description(str, optional): An optional description for the update. Defaults to None.
        replace(bool, optional): If True, then all fields that are required by the RegisterTargetWithMaintenanceWindow operation are also required for this API request. Optional fields that aren't specified are set to null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.target.update(
                ctx, window_id=value, window_target_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.target.update window_id=value, window_target_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_maintenance_window_target",
        op_kwargs={
            "WindowId": window_id,
            "WindowTargetId": window_target_id,
            "Targets": targets,
            "OwnerInformation": owner_information,
            "Name": name,
            "Description": description,
            "Replace": replace,
        },
    )
