"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    window_id: str = None,
    targets: List = None,
    resource_type: str = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about upcoming executions of a maintenance window.

    Args:
        window_id(str, optional): The ID of the maintenance window to retrieve information about. Defaults to None.
        targets(List, optional): The instance ID or key-value pair to retrieve information about. Defaults to None.
        resource_type(str, optional): The type of resource you want to retrieve information about. For example, INSTANCE. Defaults to None.
        filters(List, optional): Filters used to limit the range of results. For example, you can limit maintenance window executions to only those scheduled before or after a certain date and time. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.schedule.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.schedule.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_maintenance_window_schedule",
        op_kwargs={
            "WindowId": window_id,
            "Targets": targets,
            "ResourceType": resource_type,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
