"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    schedule: str,
    duration: int,
    cutoff: int,
    allow_unassociated_targets: bool,
    description: str = None,
    start_date: str = None,
    end_date: str = None,
    schedule_timezone: str = None,
    schedule_offset: int = None,
    client_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new maintenance window.  The value you specify for Duration determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for Cutoff. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for Cutoff is one hour, no maintenance window tasks can start after 5 PM.

    Args:
        name(str): The name of the maintenance window.
        description(str, optional): An optional description for the maintenance window. We recommend specifying a description to help you organize your maintenance windows. . Defaults to None.
        start_date(str, optional): The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. StartDate allows you to delay activation of the maintenance window until the specified future date. Defaults to None.
        end_date(str, optional): The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. EndDate allows you to set a date and time in the future when the maintenance window will no longer run. Defaults to None.
        schedule(str): The schedule of the maintenance window in the form of a cron or rate expression.
        schedule_timezone(str, optional): The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the Time Zone Database on the IANA website. Defaults to None.
        schedule_offset(int, optional): The number of days to wait after the date and time specified by a cron expression before running the maintenance window. For example, the following cron expression schedules a maintenance window to run on the third Tuesday of every month at 11:30 PM.  cron(30 23 ? * TUE#3 *)  If the schedule offset is 2, the maintenance window won't run until two days later. Defaults to None.
        duration(int): The duration of the maintenance window in hours.
        cutoff(int): The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.
        allow_unassociated_targets(bool): Enables a maintenance window task to run on managed instances, even if you haven't registered those instances as targets. If enabled, then you must specify the unregistered instances (by instance ID) when you register a task with the maintenance window. If you don't enable this option, then you must specify previously-registered targets when you register a task with the maintenance window.
        client_token(str, optional): User-provided idempotency token. Defaults to None.
        tags(List, optional): Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to identify the type of tasks it will run, the types of targets, and the environment it will run in. In this case, you could specify the following key-value pairs:    Key=TaskType,Value=AgentUpdate     Key=OS,Value=Windows     Key=Environment,Value=Production     To add tags to an existing maintenance window, use the AddTagsToResource operation. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.init.create(
                ctx,
                name=value,
                schedule=value,
                duration=value,
                cutoff=value,
                allow_unassociated_targets=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.init.create name=value, schedule=value, duration=value, cutoff=value, allow_unassociated_targets=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_maintenance_window",
        op_kwargs={
            "Name": name,
            "Description": description,
            "StartDate": start_date,
            "EndDate": end_date,
            "Schedule": schedule,
            "ScheduleTimezone": schedule_timezone,
            "ScheduleOffset": schedule_offset,
            "Duration": duration,
            "Cutoff": cutoff,
            "AllowUnassociatedTargets": allow_unassociated_targets,
            "ClientToken": client_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, window_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a maintenance window.

    Args:
        window_id(str): The ID of the maintenance window to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.init.delete(ctx, window_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.init.delete window_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_maintenance_window",
        op_kwargs={"WindowId": window_id},
    )


async def describe_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the maintenance windows in an account.

    Args:
        filters(List, optional): Optional filters used to narrow down the scope of the returned maintenance windows. Supported filter keys are Name and Enabled. For example, Name=MyMaintenanceWindow and Enabled=True. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_maintenance_windows",
        op_kwargs={
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def get(hub, ctx, window_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a maintenance window.

    Args:
        window_id(str): The ID of the maintenance window for which you want to retrieve information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.init.get(ctx, window_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.init.get window_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_maintenance_window",
        op_kwargs={"WindowId": window_id},
    )


async def update(
    hub,
    ctx,
    window_id: str,
    name: str = None,
    description: str = None,
    start_date: str = None,
    end_date: str = None,
    schedule: str = None,
    schedule_timezone: str = None,
    schedule_offset: int = None,
    duration: int = None,
    cutoff: int = None,
    allow_unassociated_targets: bool = None,
    enabled: bool = None,
    replace: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing maintenance window. Only specified parameters are modified.  The value you specify for Duration determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for Cutoff. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for Cutoff is one hour, no maintenance window tasks can start after 5 PM.

    Args:
        window_id(str): The ID of the maintenance window to update.
        name(str, optional): The name of the maintenance window. Defaults to None.
        description(str, optional): An optional description for the update request. Defaults to None.
        start_date(str, optional): The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the Time Zone Database on the IANA website. Defaults to None.
        end_date(str, optional): The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. EndDate allows you to set a date and time in the future when the maintenance window will no longer run. Defaults to None.
        schedule(str, optional): The schedule of the maintenance window in the form of a cron or rate expression. Defaults to None.
        schedule_timezone(str, optional): The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the Time Zone Database on the IANA website. Defaults to None.
        schedule_offset(int, optional): The number of days to wait after the date and time specified by a cron expression before running the maintenance window. For example, the following cron expression schedules a maintenance window to run the third Tuesday of every month at 11:30 PM.  cron(30 23 ? * TUE#3 *)  If the schedule offset is 2, the maintenance window won't run until two days later. Defaults to None.
        duration(int, optional): The duration of the maintenance window in hours. Defaults to None.
        cutoff(int, optional): The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution. Defaults to None.
        allow_unassociated_targets(bool, optional): Whether targets must be registered with the maintenance window before tasks can be defined for those targets. Defaults to None.
        enabled(bool, optional): Whether the maintenance window is enabled. Defaults to None.
        replace(bool, optional): If True, then all fields that are required by the CreateMaintenanceWindow operation are also required for this API request. Optional fields that aren't specified are set to null. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.init.update(ctx, window_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.init.update window_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_maintenance_window",
        op_kwargs={
            "WindowId": window_id,
            "Name": name,
            "Description": description,
            "StartDate": start_date,
            "EndDate": end_date,
            "Schedule": schedule,
            "ScheduleTimezone": schedule_timezone,
            "ScheduleOffset": schedule_offset,
            "Duration": duration,
            "Cutoff": cutoff,
            "AllowUnassociatedTargets": allow_unassociated_targets,
            "Enabled": enabled,
            "Replace": replace,
        },
    )
