"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    targets: List,
    resource_type: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the maintenance window targets or tasks that an instance is associated with.

    Args:
        targets(List): The instance ID or key-value pair to retrieve information about.
        resource_type(str): The type of resource you want to retrieve information about. For example, INSTANCE.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.for_target.describe(
                ctx, targets=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.for_target.describe targets=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_maintenance_windows_for_target",
        op_kwargs={
            "Targets": targets,
            "ResourceType": resource_type,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
