"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    window_execution_id: str,
    task_id: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance window execution.

    Args:
        window_execution_id(str): The ID of the maintenance window execution the task is part of.
        task_id(str): The ID of the specific task in the maintenance window task that should be retrieved.
        filters(List, optional): Optional filters used to scope down the returned task invocations. The supported filter key is STATUS with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.execution.task.invocation.describe_all(
                ctx, window_execution_id=value, task_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.execution.task.invocation.describe_all window_execution_id=value, task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_maintenance_window_execution_task_invocations",
        op_kwargs={
            "WindowExecutionId": window_execution_id,
            "TaskId": task_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def get(
    hub, ctx, window_execution_id: str, task_id: str, invocation_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a specific task running on a specific target.

    Args:
        window_execution_id(str): The ID of the maintenance window execution for which the task is a part.
        task_id(str): The ID of the specific task in the maintenance window task that should be retrieved. .
        invocation_id(str): The invocation ID to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.execution.task.invocation.get(
                ctx, window_execution_id=value, task_id=value, invocation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.execution.task.invocation.get window_execution_id=value, task_id=value, invocation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_maintenance_window_execution_task_invocation",
        op_kwargs={
            "WindowExecutionId": window_execution_id,
            "TaskId": task_id,
            "InvocationId": invocation_id,
        },
    )
