"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, window_execution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't already starting running. Tasks already in progress will continue to completion.

    Args:
        window_execution_id(str): The ID of the maintenance window execution to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.execution.init.cancel(
                ctx, window_execution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.execution.init.cancel window_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="cancel_maintenance_window_execution",
        op_kwargs={"WindowExecutionId": window_execution_id},
    )


async def describe_all(
    hub,
    ctx,
    window_id: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the executions of a maintenance window. This includes information about when the maintenance window was scheduled to be active, and information about tasks registered and run with the maintenance window.

    Args:
        window_id(str): The ID of the maintenance window whose executions should be retrieved.
        filters(List, optional): Each entry in the array is a structure containing:   Key. A string between 1 and 128 characters. Supported keys include ExecutedBefore and ExecutedAfter.   Values. An array of strings, each between 1 and 256 characters. Supported values are date/time strings in a valid ISO 8601 date/time format, such as 2021-11-04T05:00:00Z.  . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.execution.init.describe_all(
                ctx, window_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.execution.init.describe_all window_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_maintenance_window_executions",
        op_kwargs={
            "WindowId": window_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def get(hub, ctx, window_execution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details about a specific a maintenance window execution.

    Args:
        window_execution_id(str): The ID of the maintenance window execution that includes the task.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.maintenance_window.execution.init.get(
                ctx, window_execution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.maintenance_window.execution.init.get window_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_maintenance_window_execution",
        op_kwargs={"WindowExecutionId": window_execution_id},
    )
