"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    type_name: str = None,
    next_token: str = None,
    max_results: int = None,
    aggregator: bool = None,
    sub_type: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type.

    Args:
        type_name(str, optional): The type of inventory item to return. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        aggregator(bool, optional): Returns inventory schemas that support aggregation. For example, this call returns the AWS:InstanceInformation type, because it supports aggregation based on the PlatformName, PlatformType, and PlatformVersion attributes. Defaults to None.
        sub_type(bool, optional): Returns the sub-type schema for a specified inventory type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.inventory.schema.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.inventory.schema.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_inventory_schema",
        op_kwargs={
            "TypeName": type_name,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Aggregator": aggregator,
            "SubType": sub_type,
        },
    )
