"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub,
    ctx,
    type_name: str,
    schema_delete_option: str = None,
    dry_run: bool = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory type is also referred to as deleting a custom inventory schema.

    Args:
        type_name(str): The name of the custom inventory type for which you want to delete either all previously collected data or the inventory type itself. .
        schema_delete_option(str, optional): Use the SchemaDeleteOption to delete a custom inventory type (schema). If you don't choose this option, the system only deletes existing inventory data associated with the custom inventory type. Choose one of the following options: DisableSchema: If you choose this option, the system ignores all inventory data for the specified version, and any earlier versions. To enable this schema again, you must call the PutInventory operation for a version greater than the disabled version. DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the schema later, if you want. Defaults to None.
        dry_run(bool, optional): Use this option to view a summary of the deletion request without deleting any data or the data type. This option is useful when you only want to understand what will be deleted. Once you validate that the data to be deleted is what you intend to delete, you can run the same command without specifying the DryRun option. Defaults to None.
        client_token(str, optional): User-provided idempotency token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.inventory.init.delete(ctx, type_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.inventory.init.delete type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_inventory",
        op_kwargs={
            "TypeName": type_name,
            "SchemaDeleteOption": schema_delete_option,
            "DryRun": dry_run,
            "ClientToken": client_token,
        },
    )


async def get(
    hub,
    ctx,
    filters: List = None,
    aggregators: List = None,
    result_attributes: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Query inventory information.

    Args:
        filters(List, optional): One or more filters. Use a filter to return a more specific list of results. Defaults to None.
        aggregators(List, optional): Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an expression that uses the AWS:InstanceInformation.PlatformType type, you can see a count of how many Windows and Linux instances exist in your inventoried fleet. Defaults to None.
        result_attributes(List, optional): The list of inventory item types to return. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.inventory.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.inventory.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_inventory",
        op_kwargs={
            "Filters": filters,
            "Aggregators": aggregators,
            "ResultAttributes": result_attributes,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def put(hub, ctx, instance_id: str, items: List) -> Dict:
    r"""
    **Autogenerated function**

    Bulk update custom inventory items on one more instance. The request adds an inventory item, if it doesn't already exist, or updates an inventory item, if it does exist.

    Args:
        instance_id(str): An instance ID where you want to add or update inventory items.
        items(List): The inventory items that you want to add or update on instances.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.inventory.init.put(ctx, instance_id=value, items=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.inventory.init.put instance_id=value, items=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="put_inventory",
        op_kwargs={"InstanceId": instance_id, "Items": items},
    )
