"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    instance_id: str,
    type_name: str,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    A list of inventory items returned by the request.

    Args:
        instance_id(str): The instance ID for which you want inventory information.
        type_name(str): The type of inventory item for which you want information.
        filters(List, optional): One or more filters. Use a filter to return a more specific list of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.inventory.entry.list_all(
                ctx, instance_id=value, type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.inventory.entry.list_all instance_id=value, type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_inventory_entries",
        op_kwargs={
            "InstanceId": instance_id,
            "TypeName": type_name,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
